/*******************************************************************************
* File Name: TRIGGER.h  
* Version 2.20
*
* Description:
*  This file contains Pin function prototypes and register defines
*
********************************************************************************
* Copyright 2008-2015, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(CY_PINS_TRIGGER_H) /* Pins TRIGGER_H */
#define CY_PINS_TRIGGER_H

#include "cytypes.h"
#include "cyfitter.h"
#include "TRIGGER_aliases.h"


/***************************************
*     Data Struct Definitions
***************************************/

/**
* \addtogroup group_structures
* @{
*/
    
/* Structure for sleep mode support */
typedef struct
{
    uint32 pcState; /**< State of the port control register */
    uint32 sioState; /**< State of the SIO configuration */
    uint32 usbState; /**< State of the USBIO regulator */
} TRIGGER_BACKUP_STRUCT;

/** @} structures */


/***************************************
*        Function Prototypes             
***************************************/
/**
* \addtogroup group_general
* @{
*/
uint8   TRIGGER_Read(void);
void    TRIGGER_Write(uint8 value);
uint8   TRIGGER_ReadDataReg(void);
#if defined(TRIGGER__PC) || (CY_PSOC4_4200L) 
    void    TRIGGER_SetDriveMode(uint8 mode);
#endif
void    TRIGGER_SetInterruptMode(uint16 position, uint16 mode);
uint8   TRIGGER_ClearInterrupt(void);
/** @} general */

/**
* \addtogroup group_power
* @{
*/
void TRIGGER_Sleep(void); 
void TRIGGER_Wakeup(void);
/** @} power */


/***************************************
*           API Constants        
***************************************/
#if defined(TRIGGER__PC) || (CY_PSOC4_4200L) 
    /* Drive Modes */
    #define TRIGGER_DRIVE_MODE_BITS        (3)
    #define TRIGGER_DRIVE_MODE_IND_MASK    (0xFFFFFFFFu >> (32 - TRIGGER_DRIVE_MODE_BITS))

    /**
    * \addtogroup group_constants
    * @{
    */
        /** \addtogroup driveMode Drive mode constants
         * \brief Constants to be passed as "mode" parameter in the TRIGGER_SetDriveMode() function.
         *  @{
         */
        #define TRIGGER_DM_ALG_HIZ         (0x00u) /**< \brief High Impedance Analog   */
        #define TRIGGER_DM_DIG_HIZ         (0x01u) /**< \brief High Impedance Digital  */
        #define TRIGGER_DM_RES_UP          (0x02u) /**< \brief Resistive Pull Up       */
        #define TRIGGER_DM_RES_DWN         (0x03u) /**< \brief Resistive Pull Down     */
        #define TRIGGER_DM_OD_LO           (0x04u) /**< \brief Open Drain, Drives Low  */
        #define TRIGGER_DM_OD_HI           (0x05u) /**< \brief Open Drain, Drives High */
        #define TRIGGER_DM_STRONG          (0x06u) /**< \brief Strong Drive            */
        #define TRIGGER_DM_RES_UPDWN       (0x07u) /**< \brief Resistive Pull Up/Down  */
        /** @} driveMode */
    /** @} group_constants */
#endif

/* Digital Port Constants */
#define TRIGGER_MASK               TRIGGER__MASK
#define TRIGGER_SHIFT              TRIGGER__SHIFT
#define TRIGGER_WIDTH              1u

/**
* \addtogroup group_constants
* @{
*/
    /** \addtogroup intrMode Interrupt constants
     * \brief Constants to be passed as "mode" parameter in TRIGGER_SetInterruptMode() function.
     *  @{
     */
        #define TRIGGER_INTR_NONE      ((uint16)(0x0000u)) /**< \brief Disabled             */
        #define TRIGGER_INTR_RISING    ((uint16)(0x5555u)) /**< \brief Rising edge trigger  */
        #define TRIGGER_INTR_FALLING   ((uint16)(0xaaaau)) /**< \brief Falling edge trigger */
        #define TRIGGER_INTR_BOTH      ((uint16)(0xffffu)) /**< \brief Both edge trigger    */
    /** @} intrMode */
/** @} group_constants */

/* SIO LPM definition */
#if defined(TRIGGER__SIO)
    #define TRIGGER_SIO_LPM_MASK       (0x03u)
#endif

/* USBIO definitions */
#if !defined(TRIGGER__PC) && (CY_PSOC4_4200L)
    #define TRIGGER_USBIO_ENABLE               ((uint32)0x80000000u)
    #define TRIGGER_USBIO_DISABLE              ((uint32)(~TRIGGER_USBIO_ENABLE))
    #define TRIGGER_USBIO_SUSPEND_SHIFT        CYFLD_USBDEVv2_USB_SUSPEND__OFFSET
    #define TRIGGER_USBIO_SUSPEND_DEL_SHIFT    CYFLD_USBDEVv2_USB_SUSPEND_DEL__OFFSET
    #define TRIGGER_USBIO_ENTER_SLEEP          ((uint32)((1u << TRIGGER_USBIO_SUSPEND_SHIFT) \
                                                        | (1u << TRIGGER_USBIO_SUSPEND_DEL_SHIFT)))
    #define TRIGGER_USBIO_EXIT_SLEEP_PH1       ((uint32)~((uint32)(1u << TRIGGER_USBIO_SUSPEND_SHIFT)))
    #define TRIGGER_USBIO_EXIT_SLEEP_PH2       ((uint32)~((uint32)(1u << TRIGGER_USBIO_SUSPEND_DEL_SHIFT)))
    #define TRIGGER_USBIO_CR1_OFF              ((uint32)0xfffffffeu)
#endif


/***************************************
*             Registers        
***************************************/
/* Main Port Registers */
#if defined(TRIGGER__PC)
    /* Port Configuration */
    #define TRIGGER_PC                 (* (reg32 *) TRIGGER__PC)
#endif
/* Pin State */
#define TRIGGER_PS                     (* (reg32 *) TRIGGER__PS)
/* Data Register */
#define TRIGGER_DR                     (* (reg32 *) TRIGGER__DR)
/* Input Buffer Disable Override */
#define TRIGGER_INP_DIS                (* (reg32 *) TRIGGER__PC2)

/* Interrupt configuration Registers */
#define TRIGGER_INTCFG                 (* (reg32 *) TRIGGER__INTCFG)
#define TRIGGER_INTSTAT                (* (reg32 *) TRIGGER__INTSTAT)

/* "Interrupt cause" register for Combined Port Interrupt (AllPortInt) in GSRef component */
#if defined (CYREG_GPIO_INTR_CAUSE)
    #define TRIGGER_INTR_CAUSE         (* (reg32 *) CYREG_GPIO_INTR_CAUSE)
#endif

/* SIO register */
#if defined(TRIGGER__SIO)
    #define TRIGGER_SIO_REG            (* (reg32 *) TRIGGER__SIO)
#endif /* (TRIGGER__SIO_CFG) */

/* USBIO registers */
#if !defined(TRIGGER__PC) && (CY_PSOC4_4200L)
    #define TRIGGER_USB_POWER_REG       (* (reg32 *) CYREG_USBDEVv2_USB_POWER_CTRL)
    #define TRIGGER_CR1_REG             (* (reg32 *) CYREG_USBDEVv2_CR1)
    #define TRIGGER_USBIO_CTRL_REG      (* (reg32 *) CYREG_USBDEVv2_USB_USBIO_CTRL)
#endif    
    
    
/***************************************
* The following code is DEPRECATED and 
* must not be used in new designs.
***************************************/
/**
* \addtogroup group_deprecated
* @{
*/
#define TRIGGER_DRIVE_MODE_SHIFT       (0x00u)
#define TRIGGER_DRIVE_MODE_MASK        (0x07u << TRIGGER_DRIVE_MODE_SHIFT)
/** @} deprecated */

#endif /* End Pins TRIGGER_H */


/* [] END OF FILE */
